# Raspberry Pi 5 Peripheral Device Definitions

# Copyright (C)2024, Philip Munts dba Munts Technologies.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

# Raspberry Pi boards don't have a built-in ADC (Analog to Digital
# Converter) subsystem, so the following analog input designators are
# placeholders for the first IIO (Industrial I/O) ADC device.

AIN0   = (0,  0)
AIN1   = (0,  1)
AIN2   = (0,  2)
AIN3   = (0,  3)
AIN4   = (0,  4)
AIN5   = (0,  5)
AIN6   = (0,  6)
AIN7   = (0,  7)

GPIO0  = (0,  0)  # I2C0 SDA
GPIO1  = (0,  1)  # I2C0 SDA
GPIO2  = (0,  2)  # I2C1 SDA
GPIO3  = (0,  3)  # I2C1 SCL
GPIO4  = (0,  4)
GPIO5  = (0,  5)
GPIO6  = (0,  6)
GPIO7  = (0,  7)  # SPI0 SS1
GPIO8  = (0,  8)  # SPI0 SS0
GPIO9  = (0,  9)  # SPI0 MISO
GPIO10 = (0, 10)  # SPI0 MOSI
GPIO11 = (0, 11)  # SPI0 SCLK
GPIO12 = (0, 12)  # PWM0
GPIO13 = (0, 13)  # PWM1
GPIO14 = (0, 14)  # UART0 TXD
GPIO15 = (0, 15)  # UART0 RXD
GPIO16 = (0, 16)  # SPI1 SS2
GPIO17 = (0, 17)  # SPI1 SS1
GPIO18 = (0, 18)  # PWM2, SPI1 SS0
GPIO19 = (0, 19)  # PWM3, SPI1 MISO
GPIO20 = (0, 20)  # SPI1 MOSI
GPIO21 = (0, 21)  # SPI1 SCLK
GPIO22 = (0, 22)
GPIO23 = (0, 23)
GPIO24 = (0, 24)
GPIO25 = (0, 25)
GPIO26 = (0, 26)
GPIO27 = (0, 27)

# The Raspberry Pi 5 has additional I2C bus controllers, which can be
# enabled by device tree overlays i2c0-pi5, i2c1-pi5, i2c2-pi5, and
# i2c3-pi5.

I2C0   = (0,  0)  # GPIO0/GPIO1 or GPIO8/GPIO9
I2C1   = (0,  1)  # GPIO2/GPIO3 or GPIO10/GPIO11
I2C2   = (0,  2)  # GPIO4/GPIO5 or GPIO12/GPIO13
I2C3   = (0,  3)  # GPIO6/GPIO7 or GPIO14/GPIO15 or GPIO22/23

# The Raspberry Pi 5 has two more hardware PWM controllers, two more
# PWM outputs, different chip enumeration, and different pin mapping.

PWM0   = (2,  0)  # GPIO12
PWM1   = (2,  1)  # GPIO13
PWM2   = (2,  2)  # GPIO14 or GPIO18
PWM3   = (2,  3)  # GPIO15 or GPIO19

SPI0_0 = (0,  0)  # GPIO8,  GPIO9,  GPIO10, and GPIO11
SPI0_1 = (0,  1)  # GPIO7,  GPIO9,  GPIO10, and GPIO11
SPI1_0 = (1,  0)  # GPIO18, GPIO19, GPIO20, and GPIO21
SPI1_1 = (1,  1)  # GPIO17, GPIO19, GPIO20, and GPIO21
SPI1_2 = (1,  2)  # GPIO16, GPIO19, GPIO20, and GPIO21
